﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Urzedy Skarbowe</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
        <script runat="server">

            private class Pozycja {
                
                private string urzadNazwa;
                public string UrzadNazwa {
                    get { return urzadNazwa; }
                    set { urzadNazwa = value; }
                }
                
                private string urzadAdres;
                public string UrzadAdres {
                    get { return urzadAdres; }
                    set { urzadAdres = value; }
                }

                private Pracownik prac;
                public Pracownik Prac {
                    get { return prac; }
                    set { prac = value; }
                }

                public Pozycja(string urzadNazwa, string urzadAdres, Pracownik prac) {
                    this.urzadNazwa = urzadNazwa;
                    this.urzadAdres = urzadAdres;
                    this.prac = prac;
                }
            }
        
            public class PrnParams : ContextBase {

                public PrnParams(Context context) : base(context) {
                }

                bool osobno = false;
                [Caption("US na osobnych str.")]
                public bool Osobno {
                    get { return osobno; }
                    set {
                        osobno = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool podpis = false;
                [Caption("Data i podpis PIT")]
                public bool Podpis {
                    get { return podpis; }
                    set {
                        podpis = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            PrnParams pars;
            [Context(Required = true)]
            public PrnParams Params {
                get { return pars; }
                set { pars = value; }
            }
            
            class UrzadSkarbowyComparer : IComparer {
                public int Compare(object ox, object oy) {
                    string x = (string)ox;
                    string y = (string)oy;
                    return x.CompareTo(y);
                }
            }

            class PozycjaComparer : IComparer {
                public int Compare(object ox, object oy) {
                    Pozycja x = (Pozycja)ox;
                    Pozycja y = (Pozycja)oy;
                    int result = x.UrzadNazwa.CompareTo(y.UrzadNazwa);
                    if (result == 0)
                        result = x.UrzadAdres.CompareTo(y.UrzadAdres);
                    if (result == 0)
                        result = x.Prac.NazwiskoImię.CompareTo(y.Prac.NazwiskoImię);
                    return result;
                }
            }

            FromTo okres;
            Row[] rows;

            void OnContextLoad(object sender, EventArgs e) {
                okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;

                Hashtable ht = new Hashtable();
                rows = (Row[])dc[typeof(Row[])];
                if (pars.Osobno)
                    foreach (PIT11 pit in rows)
                        ht[pit.UrządSkarbowy] = true;
                else
                    ht[string.Empty] = true;
                
                ArrayList al = new ArrayList(ht.Keys);
                al.Sort(new UrzadSkarbowyComparer());                
                DataRepeater1.DataSource = al;

                colData.Visible = colPodpis.Visible = pars.Podpis;
	        }

            void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
                string us = (string)DataRepeater1.CurrentRow;

                ReportHeader1["OKRES"] = okres.ToString();

                CRMModule cm = CRMModule.GetInstance(dc);
                ArrayList al = new ArrayList();
                foreach (PIT11 pit in rows) {
                    string adres = string.Empty;
                    if (pit.UrządSkarbowy != string.Empty) {
                        UrzadSkarbowy urzad = cm.UrzedySkarbowe.WgNazwy[pit.UrządSkarbowy];
                        if (urzad != null)
                            adres = urzad.Adres.ToString();
                    }                    
                    Pozycja pz = new Pozycja(pit.UrządSkarbowy, adres, pit.Pracownik);
                    if (pars.Osobno) {
                        if (us == pit.UrządSkarbowy)
                            al.Add(pz);
                    }
                    else
                        al.Add(pz);
                }
                
                al.Sort(new PozycjaComparer());                            
                Grid1.DataSource = al;
            }        
		</script>

	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
            <ea:DataRepeater id="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" Width="100%">
				<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
			    <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
                <eb:ReportHeader id="ReportHeader1" runat="server" title="Zestawienie pracowników wg urzędów skarbowych|Okres: %OKRES%"></eb:ReportHeader>
			    <ea:Grid id="Grid1" runat="server"
                    GroupData0="UrzadNazwa" GroupData1="UrzadAdres"
                    GroupLine="Nazwa: {0}, Adres: {1}">
				    <Columns>
					    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					    <ea:GridColumn runat="server" Align="Left" DataMember="Prac.NazwiskoImię" EncodeHTML="true" Caption="Nazwisko i imię" Width="38"></ea:GridColumn>
					    <ea:GridColumn runat="server" Align="Left" DataMember="UrzadNazwa" EncodeHTML="true" Caption="Urząd skarbowy"></ea:GridColumn>
					    <ea:GridColumn runat="server" ID="colData" Caption="Data odebrania PIT" Width="16"></ea:GridColumn>
					    <ea:GridColumn runat="server" ID="colPodpis" Caption="Podpis" Width="20"></ea:GridColumn>
				    </Columns>
			    </ea:Grid>
                <eb:ReportFooter id="ReportFooter1" runat="server"></eb:ReportFooter>
				<ea:SectionMarker id="SectionMarker2" runat="server" SectionType="Footer"></ea:SectionMarker>
            </ea:DataRepeater>
		</FORM>
	</BODY>
</HTML>
